import { Link } from 'react-router-dom'
import { Palette, Phone, Mail, MapPin, Clock, Instagram, Facebook, Twitter } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <div className="footer-logo-icon-wrapper">
                <Palette size={32} strokeWidth={2.5} />
                <div className="footer-logo-glow"></div>
              </div>
              <h2 className="footer-logo-text">ArtStudio</h2>
            </div>
            <p className="footer-description">
              Раскройте свой творческий потенциал с нашими профессиональными преподавателями. 
              Изучайте различные техники рисования и создавайте уникальные произведения искусства.
            </p>
            <div className="footer-social">
              <a href="#" className="social-link">
                <Instagram size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link">
                <Facebook size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link">
                <Twitter size={20} strokeWidth={2} />
              </a>
            </div>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Навигация</h3>
            <ul className="footer-links">
              <li><Link to="/">Мои занятия</Link></li>
              <li><Link to="/enroll">Записаться</Link></li>
              <li><a href="#">Галерея работ</a></li>
              <li><a href="#">О нас</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={16} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={16} strokeWidth={2} />
                <a href="mailto:info@artstudio.ru">info@artstudio.ru</a>
              </li>
              <li>
                <MapPin size={16} strokeWidth={2} />
                <span>Москва, ул. Художников, 15</span>
              </li>
              <li>
                <Clock size={16} strokeWidth={2} />
                <span>Пн-Вс: 10:00 - 20:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 ArtStudio. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

